<?= $this->Html->css("index.css") ?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<!-- PRIMERA SECCIÓN: MAPA DE LA OFICINA PRINCIPAL -->
<section class="u-align-center u-clearfix u-container-align-center u-white u-section-3" id="carousel_ba08">
  <div class="u-align-left u-container-align-center u-container-style u-list-item u-repeater-item u-shape-rectangle u-list-item-1"
    data-animation-name="customAnimationIn" data-animation-duration="1500">
    <div class="u-container-layout u-similar-container u-valign-middle u-container-layout-1">

      <!-- TÍTULO DE LA SECCIÓN -->
      <div class="section-title">
        <h2>Nuestra Sede Principal</h2>
        <p>Ubicación estratégica en el corazón de México</p>
      </div>

      <!-- CONTENEDOR FLEXIBLE -->
      <div style="display: flex; flex-direction: row; flex-wrap: wrap; align-items: center; justify-content: center; gap: 40px;">

        <!-- COLUMNA IZQUIERDA: MAPA EMBEBIDO -->
        <div style="flex: 1 1 400px; max-width: 500px;">
          <iframe
            src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d1860.4990032178887!2d-101.71862652717147!3d21.15247762460732!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x842bc0afd4f53089%3A0x6a60c314a0cfc445!2sAsahi%20Diamond%20de%20Mexico!5e0!3m2!1ses!2smx!4v1754061617023!5m2!1ses!2smx"
            width="100%" height="300" style="border:0; border-radius: 10px;" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade">
          </iframe>
        </div>

        <!-- COLUMNA DERECHA: TEXTO -->
        <div style="flex: 1 1 400px; max-width: 500px;">
          <h3 style="font-size: 2rem; font-weight: 700; color: #cd0c36; margin-bottom: 20px;">📌 Nuestra Ubicación</h3>
          <ul style="list-style: none; padding-left: 0; font-size: 1.1rem; line-height: 2;">
            <li>📍 <strong>Ubicados estratégicamente en León, Guanajuato</strong></li>
            <li>🚚 <strong>Atendemos a toda la república mexicana</strong></li>
            <li>🏭 <strong>Presencia nacional con infraestructura propia</strong></li>
          </ul>
        </div>

      </div>

    </div>
  </div>
</section>

<!-- SEGUNDA SECCIÓN: MAPA INTERACTIVO CON TODAS LAS UBICACIONES -->
<section class="u-align-center u-clearfix u-container-align-center u-white u-section-4" id="carousel_ca09">
  <div class="u-align-left u-container-align-center u-container-style u-list-item u-repeater-item u-shape-rectangle u-list-item-2"
    data-animation-name="customAnimationIn" data-animation-duration="1500">
    <div class="u-container-layout u-similar-container u-valign-middle u-container-layout-2">

      <!-- TÍTULO DE LA SECCIÓN -->
      <div class="section-title">
        <h2>Nuestra Red Nacional</h2>
        <p>Contamos con presencia estratégica en múltiples ciudades de México</p>
      </div>

      <!-- CONTENEDOR FLEXIBLE -->
      <div class="locations-container">

        <!-- COLUMNA IZQUIERDA: MAPA INTERACTIVO -->
        <div class="map-column">
          <div id="offices-map"></div>
          <div class="map-legend">
            <div class="legend-item">
              <span class="legend-icon main-office"></span>
              <span>Oficina Principal</span>
            </div>
            <div class="legend-item">
              <span class="legend-icon branch-office"></span>
              <span>Oficinas Regionales</span>
            </div>
          </div>
        </div>

        <!-- COLUMNA DERECHA: LISTA DE UBICACIONES -->
        <div class="locations-column">
          <div class="location-cards">
            <!-- OFICINA PRINCIPAL -->
            <div class="location-card active" data-location="leon">
              <div class="location-header">
                <h3>🏢 Oficina Principal</h3>
                <span class="location-badge principal">Principal</span>
              </div>
              <h4 class="location-name">León, Guanajuato</h4>
              <p class="location-address">📍 Asahi Diamond de Mexico</p>
              <p class="location-description">Nuestra sede central desde donde coordinamos operaciones a nivel nacional.</p>
            </div>

            <!-- OFICINAS REGIONALES -->
            <div class="location-card" data-location="monterrey">
              <div class="location-header">
                <h3>🏭 Oficina Regional</h3>
                <span class="location-badge regional">Regional</span>
              </div>
              <h4 class="location-name">Monterrey, Nuevo León</h4>
              <p class="location-description">Atención especializada para la región industrial del norte del país.</p>
            </div>

            <div class="location-card" data-location="sonora">
              <div class="location-header">
                <h3>🏭 Oficina Regional</h3>
                <span class="location-badge regional">Regional</span>
              </div>
              <h4 class="location-name">Sonora</h4>
              <p class="location-description">Cobertura para la importante zona minera e industrial del noroeste.</p>
            </div>

            <div class="location-card" data-location="queretaro">
              <div class="location-header">
                <h3>🏭 Oficina Regional</h3>
                <span class="location-badge regional">Regional</span>
              </div>
              <h4 class="location-name">Querétaro</h4>
              <p class="location-description">Servicio para el corredor industrial del Bajío.</p>
            </div>

            <div class="location-card" data-location="saltillo">
              <div class="location-header">
                <h3>🏭 Oficina Regional</h3>
                <span class="location-badge regional">Regional</span>
              </div>
              <h4 class="location-name">Saltillo, Coahuila</h4>
              <p class="location-description">Atención para la industria automotriz y manufacturera de la región.</p>
            </div>
          </div>
        </div>

      </div>

    </div>
  </div>
</section>

<style>
  /* ESTILOS PARA LA SECCIÓN DE UBICACIONES */
  .section-title {
    text-align: center;
    margin-bottom: 40px;
  }
  
  .section-title h2 {
    font-size: 2.5rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 10px;
  }
  
  .section-title p {
    font-size: 1.2rem;
    color: #666;
    max-width: 600px;
    margin: 0 auto;
  }
  
  .locations-container {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    align-items: stretch;
    justify-content: center;
    gap: 40px;
  }
  
  .map-column {
    flex: 1 1 500px;
    max-width: 600px;
    display: flex;
    flex-direction: column;
  }
  
  #offices-map {
    height: 400px;
    width: 100%;
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    margin-bottom: 15px;
  }
  
  .map-legend {
    display: flex;
    justify-content: center;
    gap: 20px;
    flex-wrap: wrap;
  }
  
  .legend-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 0.9rem;
  }
  
  .legend-icon {
    width: 16px;
    height: 16px;
    border-radius: 50%;
    display: inline-block;
  }
  
  .legend-icon.main-office {
    background-color: #cd0c36;
    border: 2px solid white;
    box-shadow: 0 0 0 2px #cd0c36;
  }
  
  .legend-icon.branch-office {
    background-color: #3498db;
    border: 2px solid white;
    box-shadow: 0 0 0 2px #3498db;
  }
  
  .locations-column {
    flex: 1 1 400px;
    max-width: 500px;
  }
  
  .location-cards {
    display: flex;
    flex-direction: column;
    gap: 20px;
    max-height: 500px;
    overflow-y: auto;
    padding-right: 10px;
  }
  
  .location-card {
    background: white;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    border-left: 4px solid #3498db;
    transition: all 0.3s ease;
    cursor: pointer;
  }
  
  .location-card.active, .location-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    border-left-color: #cd0c36;
  }
  
  .location-card.principal {
    border-left-color: #cd0c36;
  }
  
  .location-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 10px;
  }
  
  .location-header h3 {
    font-size: 1.2rem;
    margin: 0;
    color: #333;
  }
  
  .location-badge {
    font-size: 0.7rem;
    padding: 3px 8px;
    border-radius: 12px;
    font-weight: bold;
    text-transform: uppercase;
  }
  
  .location-badge.principal {
    background-color: #cd0c36;
    color: white;
  }
  
  .location-badge.regional {
    background-color: #3498db;
    color: white;
  }
  
  .location-name {
    font-size: 1.1rem;
    font-weight: 600;
    color: #333;
    margin: 5px 0;
  }
  
  .location-address {
    color: #666;
    margin: 5px 0;
  }
  
  .location-description {
    color: #777;
    font-size: 0.95rem;
    margin: 10px 0 0;
    line-height: 1.4;
  }
  
  /* Personalización de los popups del mapa */
  .leaflet-popup-content-wrapper {
    border-radius: 8px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.2);
  }
  
  .leaflet-popup-content {
    margin: 12px 15px;
  }
  
  .map-popup-title {
    font-weight: bold;
    color: #333;
    margin-bottom: 5px;
  }
  
  .map-popup-address {
    color: #666;
    font-size: 0.9rem;
  }
  
  /* Scrollbar personalizado para la lista de ubicaciones */
  .location-cards::-webkit-scrollbar {
    width: 6px;
  }
  
  .location-cards::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
  }
  
  .location-cards::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 10px;
  }
  
  .location-cards::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
  }
  
  /* Responsive */
  @media (max-width: 992px) {
    .locations-container {
      flex-direction: column;
    }
    
    .map-column, .locations-column {
      max-width: 100%;
    }
    
    #offices-map {
      height: 350px;
    }
  }
</style>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    // Coordenadas de las oficinas (lat, lng)
    const offices = {
      leon: {
        coords: [21.1524776, -101.7186265],
        name: "Oficina Principal - León",
        address: "Asahi Diamond de Mexico",
        type: "principal"
      },
      monterrey: {
        coords: [25.6866142, -100.3161126],
        name: "Oficina Regional - Monterrey",
        address: "Monterrey, Nuevo León",
        type: "regional"
      },
      sonora: {
        coords: [29.2972072, -110.3308822],
        name: "Oficina Regional - Sonora",
        address: "Sonora",
        type: "regional"
      },
      queretaro: {
        coords: [20.5887932, -100.3898881],
        name: "Oficina Regional - Querétaro",
        address: "Querétaro",
        type: "regional"
      },
      saltillo: {
        coords: [25.4232108, -101.0053025],
        name: "Oficina Regional - Saltillo",
        address: "Saltillo, Coahuila",
        type: "regional"
      }
    };

    // Inicializar el mapa
    const map = L.map('offices-map').setView([23.634501, -102.552784], 5);

    // Añadir capa de tiles (puedes cambiar el estilo del mapa aquí)
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(map);

    // Iconos personalizados para los marcadores
    const principalIcon = L.divIcon({
      html: '<div style="background-color: #cd0c36; width: 20px; height: 20px; border-radius: 50%; border: 3px solid white; box-shadow: 0 0 0 3px #cd0c36;"></div>',
      iconSize: [20, 20],
      className: 'principal-marker'
    });

    const regionalIcon = L.divIcon({
      html: '<div style="background-color: #3498db; width: 16px; height: 16px; border-radius: 50%; border: 2px solid white; box-shadow: 0 0 0 2px #3498db;"></div>',
      iconSize: [16, 16],
      className: 'regional-marker'
    });

    // Añadir marcadores al mapa
    Object.keys(offices).forEach(key => {
      const office = offices[key];
      const icon = office.type === 'principal' ? principalIcon : regionalIcon;
      
      const marker = L.marker(office.coords, { icon: icon }).addTo(map);
      
      marker.bindPopup(`
        <div class="map-popup">
          <div class="map-popup-title">${office.name}</div>
          <div class="map-popup-address">${office.address}</div>
        </div>
      `);
      
      // Al hacer clic en un marcador, resaltar la tarjeta correspondiente
      marker.on('click', function() {
        highlightLocationCard(key);
      });
    });

    // Interacción entre las tarjetas y el mapa
    const locationCards = document.querySelectorAll('.location-card');
    
    locationCards.forEach(card => {
      card.addEventListener('click', function() {
        const locationKey = this.getAttribute('data-location');
        highlightLocationCard(locationKey);
        
        // Centrar el mapa en la ubicación seleccionada
        if (offices[locationKey]) {
          map.setView(offices[locationKey].coords, 10);
          
          // Abrir el popup del marcador
          // Nota: En una implementación real, necesitarías una referencia a cada marcador
          // Para simplificar, solo centramos el mapa
        }
      });
    });

    function highlightLocationCard(locationKey) {
      // Quitar la clase active de todas las tarjetas
      locationCards.forEach(card => {
        card.classList.remove('active');
      });
      
      // Añadir la clase active a la tarjeta seleccionada
      const selectedCard = document.querySelector(`.location-card[data-location="${locationKey}"]`);
      if (selectedCard) {
        selectedCard.classList.add('active');
        
        // Scroll suave para mostrar la tarjeta si está parcialmente fuera de vista
        selectedCard.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
      }
    }
  });
</script>