         <?= $this->Html->css("index.css") ?>

<section id="sustentabilidad" class="sustainability-policy">
  <div class="policy-header">
    <h2 class="policy-main-title">Política de Sustentabilidad</h2>
    <div class="policy-intro">
      <h3 class="policy-subtitle">Política básica de sustentabilidad</h3>
      <div class="intro-content">
        <p class="highlight-text">
          Con nuestra filosofía de gestión <strong>“Fabricar emoción mediante la innovación”</strong> como base de todas nuestras actividades,
          nuestro grupo seguirá desarrollando a las personas, perfeccionando la tecnología y transformando lo “imposible” en “posible” para la sociedad.
          Continuaremos trabajando en conjunto con la sociedad.
        </p>
        
        <div class="policy-overview">
          <div class="overview-icon">📋</div>
          <p>
            El Grupo Asahi Diamond ha establecido los siguientes <strong>10 apartados</strong> de su Política de Sustentabilidad como lineamientos
            básicos a observar por cada director y colaborador, a fin de practicar nuestra filosofía de gestión, contribuir a la sociedad a través de
            nuestro negocio y lograr un crecimiento sostenible junto con nuestros grupos de interés.
          </p>
        </div>
      </div>
    </div>
  </div>

  <!-- NAVEGACIÓN RÁPIDA -->
  <div class="policy-nav">
    <h4>Navegación Rápida</h4>
    <div class="nav-links">
      <a href="#derechos-humanos" class="nav-link">👥 Derechos Humanos</a>
      <a href="#comunidad" class="nav-link">🏘️ Comunidad</a>
      <a href="#ambiente-laboral" class="nav-link">💼 Ambiente Laboral</a>
      <a href="#medio-ambiente" class="nav-link">🌍 Medio Ambiente</a>
      <a href="#clientes-proveedores" class="nav-link">🤝 Clientes y Proveedores</a>
      <a href="#productos-servicios" class="nav-link">📦 Productos y Servicios</a>
      <a href="#comercio-justo" class="nav-link">⚖️ Comercio Justo</a>
      <a href="#divulgacion" class="nav-link">📊 Divulgación</a>
      <a href="#activos" class="nav-link">🔒 Activos</a>
      <a href="#obligaciones" class="nav-link">👨‍💼 Obligaciones</a>
    </div>
  </div>

  <!-- CONTENIDO DE LAS POLÍTICAS -->
  <div class="policy-content">
    
    <!-- 1. DERECHOS HUMANOS -->
    <div class="policy-section" id="derechos-humanos">
      <div class="section-header">
        <span class="section-number">1</span>
        <h3 class="section-title">Derechos Humanos</h3>
        <span class="section-icon">👥</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Respeto a los derechos humanos y prohibición de trato discriminatorio</h4>
          <p>Respetamos los derechos humanos de todas las personas y no discriminamos por nacionalidad, raza, credo, edad, género, orientación sexual, estatus social o discapacidad.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Garantizar la diversidad y la aceptación</h4>
          <p>Respetamos la diversidad de ideas y valores, potenciamos las capacidades y la satisfacción laboral de cada persona.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Prohibición de acoso</h4>
          <p>Respetamos el carácter y la dignidad de todas las personas y no incurrimos en conductas de acoso.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Prohibición de trabajo forzoso e infantil</h4>
          <p>Cumplimos las leyes laborales de cada país y región y eliminamos el trabajo forzoso o involuntario.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Respeto a los derechos laborales básicos</h4>
          <p>Respetamos los derechos laborales básicos, incluido el derecho de sindicación y de negociación colectiva.</p>
        </div>
      </div>
    </div>

    <!-- 2. COMUNIDAD -->
    <div class="policy-section" id="comunidad">
      <div class="section-header">
        <span class="section-number">2</span>
        <h3 class="section-title">Comunidad</h3>
        <span class="section-icon">🏘️</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Adaptación a las necesidades sociales</h4>
          <p>Reconocemos que todas nuestras actividades impactan a la sociedad y actuamos en consonancia con sus demandas.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Comunicación local y contribución social</h4>
          <p>Promovemos actividades empresariales que respeten el arraigo de los residentes a sus comunidades.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Ruptura de relaciones con fuerzas antisociales</h4>
          <p>No mantenemos relación alguna con fuerzas antisociales que amenacen el orden y la seguridad.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Relación con la política</h4>
          <p>Mantenemos vínculos transparentes y justos con la política y cumplimos las leyes aplicables.</p>
        </div>
      </div>
    </div>

    <!-- 3. AMBIENTE LABORAL -->
    <div class="policy-section" id="ambiente-laboral">
      <div class="section-header">
        <span class="section-number">3</span>
        <h3 class="section-title">Ambiente Laboral</h3>
        <span class="section-icon">💼</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Cumplimiento de leyes y reglamentos laborales</h4>
          <p>Cumplimos las leyes laborales de cada país y región y llevamos a cabo una gestión de empleo adecuada.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Salud y seguridad</h4>
          <p>Reconocemos que la seguridad es un requisito previo para operar; mantenemos un entorno de trabajo seguro.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Creación de un gran lugar para trabajar</h4>
          <p>Impulsamos la autogestión del equilibrio vida–trabajo mediante sistemas que apoyen estilos laborales diversos.</p>
        </div>
      </div>
    </div>

    <!-- 4. MEDIO AMBIENTE -->
    <div class="policy-section" id="medio-ambiente">
      <div class="section-header">
        <span class="section-number">4</span>
        <h3 class="section-title">Medio Ambiente Global</h3>
        <span class="section-icon">🌍</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Cumplimiento de la normativa ambiental</h4>
          <p>Desarrollamos nuestras actividades cumpliendo la normativa ambiental de cada país y región.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Preservación del medio ambiente</h4>
          <p>Protegemos el ambiente y prevenimos la contaminación reduciendo gases de efecto invernadero.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Contribución a una sociedad en armonía con la naturaleza</h4>
          <p>Profundizamos en el conocimiento ambiental y consideramos el impacto ecológico de nuestras actividades.</p>
        </div>
      </div>
    </div>

    <!-- 5. CLIENTES Y PROVEEDORES -->
    <div class="policy-section" id="clientes-proveedores">
      <div class="section-header">
        <span class="section-number">5</span>
        <h3 class="section-title">Clientes y Proveedores</h3>
        <span class="section-icon">🤝</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Prohibición de soborno</h4>
          <p>Cumplimos las leyes aplicables y no prometemos, ofrecemos ni exigimos beneficios a cambio de favores.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Entretenimiento, obsequios e invitaciones moderados</h4>
          <p>Actuamos con moderación y sentido común respecto a atenciones de negocio, obsequios e invitaciones.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Alianzas</h4>
          <p>Respetamos a proveedores como aliados de negocio y trabajamos con ellos exigiendo cumplimiento normativo.</p>
        </div>
      </div>
    </div>

    <!-- 6. PRODUCTOS Y SERVICIOS -->
    <div class="policy-section" id="productos-servicios">
      <div class="section-header">
        <span class="section-number">6</span>
        <h3 class="section-title">Productos y Servicios</h3>
        <span class="section-icon">📦</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Comprensión y cumplimiento de reglas de calidad</h4>
          <p>Entendemos y cumplimos las leyes y reglas internas sobre la calidad de productos y servicios.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Garantizar seguridad y confiabilidad</h4>
          <p>Cumplimos los estándares de seguridad y tomamos medidas para prevenir daños a la vida e integridad.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Desde la perspectiva del cliente</h4>
          <p>Diseñamos el negocio desde la mirada del cliente con un compromiso absoluto con la calidad.</p>
        </div>
      </div>
    </div>

    <!-- 7. COMERCIO JUSTO -->
    <div class="policy-section" id="comercio-justo">
      <div class="section-header">
        <span class="section-number">7</span>
        <h3 class="section-title">Comercio Leal e Internacional</h3>
        <span class="section-icon">⚖️</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Comercio leal</h4>
          <p>Cumplimos las leyes sobre competencia y comercio justo en cada país y región.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Prohibición de abuso de posición dominante</h4>
          <p>No perjudicamos a socios abusando de una posición superior.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Respeto al código de conducta en transacciones internacionales</h4>
          <p>Respetamos religión, costumbres, cultura y tradiciones locales.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Cumplimiento de leyes de importación/exportación</h4>
          <p>Seguimos los procedimientos apropiados para la importación y exportación de bienes.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">No uso de minerales de conflicto</h4>
          <p>No utilizamos minerales de conflicto que se sospeche involucren a grupos armados.</p>
        </div>
      </div>
    </div>

    <!-- 8. DIVULGACIÓN -->
    <div class="policy-section" id="divulgacion">
      <div class="section-header">
        <span class="section-number">8</span>
        <h3 class="section-title">Divulgación de Información</h3>
        <span class="section-icon">📊</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Divulgación oportuna y adecuada</h4>
          <p>Divulgamos información financiera y corporativa relevante de manera oportuna y adecuada.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Solvencia de la información financiera</h4>
          <p>Preparamos y divulgamos estados financieros conforme a leyes y principios contables.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Cumplimiento fiscal adecuado</h4>
          <p>Mantenemos un conocimiento sólido de la normativa tributaria y realizamos pagos fiscales correctos.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Prohibición de uso de información privilegiada</h4>
          <p>No realizamos operaciones con valores utilizando información material no pública.</p>
        </div>
      </div>
    </div>

    <!-- 9. ACTIVOS -->
    <div class="policy-section" id="activos">
      <div class="section-header">
        <span class="section-number">9</span>
        <h3 class="section-title">Preservación y Gestión de Activos</h3>
        <span class="section-icon">🔒</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Protección y uso eficaz de activos</h4>
          <p>Protegemos cuidadosamente y utilizamos eficazmente los activos tangibles e intangibles.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Protección de la propiedad intelectual</h4>
          <p>Reconocemos la propiedad intelectual como un activo importante y trabajamos para preservarla.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Gestión y uso adecuado de la información</h4>
          <p>Utilizamos de forma efectiva la información confidencial dentro del propósito previsto.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Protección de los sistemas de información</h4>
          <p>Implementamos medidas defensivas frente a amenazas en redes informáticas.</p>
        </div>
      </div>
    </div>

    <!-- 10. OBLIGACIONES -->
    <div class="policy-section" id="obligaciones">
      <div class="section-header">
        <span class="section-number">10</span>
        <h3 class="section-title">Obligaciones de Directivos y Empleados</h3>
        <span class="section-icon">👨‍💼</span>
      </div>
      <div class="section-content">
        <div class="policy-point">
          <h4 class="point-title">Prácticas de cumplimiento</h4>
          <p>Cumplimos las leyes de los países donde operamos y actuamos con integridad.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Responsabilidad de la alta dirección</h4>
          <p>La dirección lidera el cumplimiento de las leyes y de esta Política de Sustentabilidad.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Prohibición de conflictos de interés</h4>
          <p>No realizamos actos que beneficien a nosotros o a terceros en detrimento de la empresa.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Respuesta ante violaciones</h4>
          <p>Reportamos de inmediato incumplimientos legales o internos para su investigación.</p>
        </div>
        <div class="policy-point">
          <h4 class="point-title">Gestión de crisis y continuidad del negocio</h4>
          <p>Elaboramos medidas de respuesta ante emergencias basadas en diversos escenarios.</p>
        </div>
      </div>
    </div>

  </div>

  <!-- FOOTER DE LA POLÍTICA -->
  <div class="policy-footer">
    <div class="commitment-box">
      <h4>Nuestro Compromiso</h4>
      <p>Actuamos de forma adecuada cumpliendo estrictamente con la ética corporativa y el cumplimiento normativo para realizar una sociedad sostenible y asegurar el desarrollo continuo y sólido del Grupo hacia el futuro.</p>
      <div class="commitment-badge">
        <span>♻️ Sustentabilidad</span>
        <span>🤝 Compromiso</span>
        <span>🌱 Futuro Sostenible</span>
      </div>
    </div>
  </div>
</section>

<style>
.sustainability-policy {
  max-width: 1200px;
  margin: 0 auto;
  padding: 40px 20px;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  line-height: 1.6;
  color: #333;
}

/* HEADER */
.policy-header {
  text-align: center;
  margin-bottom: 50px;
  padding: 40px 0;
  background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
  border-radius: 15px;
}

.policy-main-title {
  font-size: 2.8rem;
  font-weight: 700;
  color: #2c5530;
  margin-bottom: 20px;
  background: linear-gradient(135deg, #2c5530, #4a7c59);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}

.policy-subtitle {
  font-size: 1.5rem;
  color: #4a7c59;
  margin-bottom: 25px;
  font-weight: 600;
}

.intro-content {
  max-width: 800px;
  margin: 0 auto;
}

.highlight-text {
  font-size: 1.2rem;
  background: rgba(76, 175, 80, 0.1);
  padding: 25px;
  border-radius: 10px;
  border-left: 5px solid #4a7c59;
  margin-bottom: 25px;
}

.policy-overview {
  display: flex;
  align-items: center;
  gap: 20px;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 5px 15px rgba(0,0,0,0.08);
}

.overview-icon {
  font-size: 3rem;
  flex-shrink: 0;
}

/* NAVEGACIÓN */
.policy-nav {
  background: white;
  padding: 25px;
  border-radius: 15px;
  box-shadow: 0 5px 20px rgba(0,0,0,0.1);
  margin-bottom: 40px;
  position: sticky;
  top: 20px;
  z-index: 100;
}

.policy-nav h4 {
  color: #2c5530;
  margin-bottom: 15px;
  font-size: 1.3rem;
}

.nav-links {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
  gap: 10px;
}

.nav-link {
  display: flex;
  align-items: center;
  gap: 10px;
  padding: 12px 15px;
  background: #f8f9fa;
  border-radius: 8px;
  text-decoration: none;
  color: #495057;
  font-weight: 500;
  transition: all 0.3s ease;
  border: 1px solid transparent;
}

.nav-link:hover {
  background: #4a7c59;
  color: white;
  transform: translateY(-2px);
  box-shadow: 0 5px 15px rgba(74, 124, 89, 0.3);
}

/* SECCIONES DE CONTENIDO */
.policy-content {
  display: flex;
  flex-direction: column;
  gap: 30px;
}

.policy-section {
  background: white;
  border-radius: 15px;
  overflow: hidden;
  box-shadow: 0 5px 20px rgba(0,0,0,0.08);
  transition: transform 0.3s ease, box-shadow 0.3s ease;
  border: 1px solid #e9ecef;
}

.policy-section:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 30px rgba(0,0,0,0.15);
}

.section-header {
  background: linear-gradient(135deg, #4a7c59, #2c5530);
  color: white;
  padding: 25px 30px;
  display: flex;
  align-items: center;
  gap: 20px;
}

.section-number {
  font-size: 2.5rem;
  font-weight: 700;
  opacity: 0.9;
}

.section-title {
  font-size: 1.8rem;
  font-weight: 600;
  margin: 0;
  flex: 1;
}

.section-icon {
  font-size: 2rem;
}

.section-content {
  padding: 30px;
}

.policy-point {
  margin-bottom: 25px;
  padding-bottom: 25px;
  border-bottom: 1px solid #e9ecef;
}

.policy-point:last-child {
  margin-bottom: 0;
  padding-bottom: 0;
  border-bottom: none;
}

.point-title {
  color: #2c5530;
  font-size: 1.2rem;
  font-weight: 600;
  margin-bottom: 10px;
  display: flex;
  align-items: center;
  gap: 10px;
}

.point-title::before {
  content: "•";
  color: #4a7c59;
  font-size: 1.5rem;
}

/* FOOTER */
.policy-footer {
  margin-top: 50px;
}

.commitment-box {
  background: linear-gradient(135deg, #2c5530, #4a7c59);
  color: white;
  padding: 40px;
  border-radius: 15px;
  text-align: center;
}

.commitment-box h4 {
  font-size: 1.8rem;
  margin-bottom: 20px;
  font-weight: 600;
}

.commitment-badge {
  display: flex;
  justify-content: center;
  gap: 20px;
  margin-top: 25px;
  flex-wrap: wrap;
}

.commitment-badge span {
  background: rgba(255,255,255,0.2);
  padding: 10px 20px;
  border-radius: 25px;
  font-weight: 500;
  backdrop-filter: blur(10px);
}

/* RESPONSIVE */
@media (max-width: 768px) {
  .sustainability-policy {
    padding: 20px 15px;
  }
  
  .policy-main-title {
    font-size: 2.2rem;
  }
  
  .policy-overview {
    flex-direction: column;
    text-align: center;
  }
  
  .section-header {
    flex-direction: column;
    text-align: center;
    gap: 10px;
    padding: 20px;
  }
  
  .nav-links {
    grid-template-columns: 1fr;
  }
  
  .commitment-badge {
    flex-direction: column;
    align-items: center;
  }
  
  .section-content {
    padding: 20px;
  }
}

@media (max-width: 480px) {
  .policy-main-title {
    font-size: 1.8rem;
  }
  
  .section-title {
    font-size: 1.4rem;
  }
  
  .highlight-text {
    padding: 15px;
    font-size: 1.1rem;
  }
  
  .commitment-box {
    padding: 25px 20px;
  }
}
</style>