         <?= $this->Html->css("index.css") ?>
<section id="politica-ambiental" class="environmental-policy">
  <div class="policy-header">
    <h2 class="policy-main-title">Iniciativas Ambientales</h2>
    <div class="policy-intro">
      <h3 class="policy-subtitle">Filosofía Básica</h3>
      <div class="intro-content">
        <p class="highlight-text">
          <strong>Manufactura que contribuye a la realización de una sociedad sostenible</strong>
        </p>
      </div>
    </div>
  </div>

  <!-- POLÍTICA AMBIENTAL -->
  <div class="policy-content-section">
    <div class="section-header">
      <span class="section-icon">🌱</span>
      <h3 class="section-title">Política Ambiental</h3>
    </div>
    
    <div class="policy-points">
      <div class="policy-point">
        <div class="point-icon">🎯</div>
        <div class="point-content">
          <h4 class="point-title">Identificación del Impacto Ambiental</h4>
          <p>Identificar correctamente el impacto ambiental de nuestros productos y actividades.</p>
        </div>
      </div>

      <div class="policy-point">
        <div class="point-icon">♻️</div>
        <div class="point-content">
          <h4 class="point-title">Iniciativas de Protección Ambiental</h4>
          <p>Promoveremos la protección ambiental a través de las siguientes iniciativas:</p>
          <ul class="initiatives-list">
            <li class="initiative-item">
              <span class="initiative-bullet">•</span>
              <span>Desarrollo de productos que contribuyan a la realización de un medio ambiente global sostenible</span>
            </li>
            <li class="initiative-item">
              <span class="initiative-bullet">•</span>
              <span>Reducción del calentamiento global mediante la reducción del consumo energético</span>
            </li>
            <li class="initiative-item">
              <span class="initiative-bullet">•</span>
              <span>Prevención de la contaminación ambiental mediante la reducción de residuos industriales y sustancias peligrosas</span>
            </li>
          </ul>
        </div>
      </div>

      <div class="policy-point">
        <div class="point-icon">⚖️</div>
        <div class="point-content">
          <h4 class="point-title">Cumplimiento Normativo</h4>
          <p>Cumplir con las leyes, regulaciones y requisitos aplicables relevantes.</p>
        </div>
      </div>

      <div class="policy-point">
        <div class="point-icon">🎯</div>
        <div class="point-content">
          <h4 class="point-title">Establecimiento de Metas</h4>
          <p>Para lograr estos objetivos, se establecerán metas ambientales y todos los empleados trabajarán juntos para alcanzarlas.</p>
        </div>
      </div>

      <div class="policy-point">
        <div class="point-icon">📈</div>
        <div class="point-content">
          <h4 class="point-title">Mejora Continua</h4>
          <p>Mejorar continuamente el sistema de gestión ambiental.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- SISTEMA DE GESTIÓN AMBIENTAL -->
  <div class="ems-section">
    <div class="section-header">
      <span class="section-icon">🏅</span>
      <h3 class="section-title">Sistema de Gestión Ambiental</h3>
    </div>
    
    <div class="ems-content">
      <div class="certification-info">
        <div class="certification-badge">
          <span class="badge-icon">✅</span>
          <span class="badge-text">ISO 14001 Certificado</span>
        </div>
        <p>
          Hemos establecido un EMS (Sistema de Gestión Ambiental), y todas nuestras plantas nacionales, 
          así como Yamanashi Asahi Diamond Industries, Ltd. y Koremura Asahi Diamond Industries, Ltd. 
          y nuestra subsidiaria europea Asahi Diamond Europe han obtenido la certificación ISO 14001.
        </p>
      </div>

      <div class="product-impact">
        <h4 class="impact-title">Productos Amigables con el Medio Ambiente</h4>
        <p>
          Nuestros productos principales, las herramientas de diamante, son ampliamente utilizadas como 
          herramientas ecológicas. Entre ellas, nuestro hilo de diamante electrodepositado "EcoMEP" 
          puede reducir significativamente las emisiones de gases de efecto invernadero (CO2) durante 
          su uso en comparación con el método convencional de abrasivos sueltos.
        </p>
        <div class="applications">
          <div class="application-item">
            <span class="app-icon">☀️</span>
            <span class="app-text">Paneles Solares</span>
          </div>
          <div class="application-item">
            <span class="app-icon">💡</span>
            <span class="app-text">Sustratos de Zafiro para LEDs</span>
          </div>
        </div>
      </div>

      <div class="additional-initiatives">
        <h4 class="initiatives-title">Otras Iniciativas Ambientales</h4>
        <div class="initiatives-grid">
          <div class="initiative-card">
            <div class="card-icon">📋</div>
            <h5 class="card-title">Directrices de Compra Verde</h5>
            <p class="card-description">Promovemos la fabricación de productos ecológicos a través de nuestras "Directrices de Compra Verde".</p>
          </div>
          <div class="initiative-card">
            <div class="card-icon">🌍</div>
            <h5 class="card-title">Reducción de Emisiones</h5>
            <p class="card-description">Esfuerzos a nivel empresarial para reducir las emisiones de gases de efecto invernadero (CO2).</p>
          </div>
          <div class="initiative-card">
            <div class="card-icon">🎓</div>
            <h5 class="card-title">Educación Ambiental</h5>
            <p class="card-description">Programas de educación y concienciación ambiental para empleados.</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- HISTORIAL DE CERTIFICACIÓN ISO 14001 -->
  <div class="certification-history">
    <div class="section-header">
      <span class="section-icon">📅</span>
      <h3 class="section-title">Historial de Certificación ISO 14001</h3>
    </div>
    
    <div class="timeline">
      <div class="timeline-item">
        <div class="timeline-date">Enero 2004</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Certificación Inicial</h4>
          <p>Todas las plantas nacionales y Yamanashi Asahi Diamond Industrial obtuvieron la certificación ISO 14001:1996 de JCQA (Japan Chemical Quality Assurance)</p>
          <div class="certification-details">
            <span class="cert-number">Número de Registro: JCQA-E-0530</span>
          </div>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Enero 2006</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Transición a Nueva Versión</h4>
          <p>Todas las plantas nacionales y Yamanashi Asahi Diamond Industrial obtuvieron la certificación ISO 14001:1996 de JCQA (Japan Chemical Quality Assurance)</p>
          <div class="certification-details">
            <span class="cert-number">Número de Registro: JCQA-E-0530</span>
          </div>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Diciembre 2016</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Actualización del Sistema</h4>
          <p>Transición a ISO 14001:2015 e integración de Koremura Co.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- COMPROMISO FINAL -->
  <div class="commitment-section">
    <div class="commitment-content">
      <h3 class="commitment-title">Nuestro Compromiso Ambiental</h3>
      <p class="commitment-text">
        Continuamos implementando medidas ambientales a medio y largo plazo, 
        contribuyendo significativamente al medio ambiente a través de productos 
        y procesos innovadores.
      </p>
      <div class="commitment-badges">
        <div class="badge">
          <span class="badge-emoji">🌱</span>
          <span class="badge-label">Sostenibilidad</span>
        </div>
        <div class="badge">
          <span class="badge-emoji">♻️</span>
          <span class="badge-label">Innovación Ecológica</span>
        </div>
        <div class="badge">
          <span class="badge-emoji">🏆</span>
          <span class="badge-label">Calidad Certificada</span>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
.environmental-policy {
  max-width: 1200px;
  margin: 0 auto;
  padding: 40px 20px;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  line-height: 1.6;
  color: #333;
}

/* HEADER */
.policy-header {
  text-align: center;
  margin-bottom: 50px;
  padding: 40px 0;
  background: linear-gradient(135deg, #e8f5e8 0%, #c8e6c9 100%);
  border-radius: 15px;
}

.policy-main-title {
  font-size: 2.8rem;
  font-weight: 700;
  color: #2e7d32;
  margin-bottom: 20px;
  background: linear-gradient(135deg, #2e7d32, #4caf50);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}

.policy-subtitle {
  font-size: 1.5rem;
  color: #388e3c;
  margin-bottom: 25px;
  font-weight: 600;
}

.highlight-text {
  font-size: 1.3rem;
  background: rgba(76, 175, 80, 0.1);
  padding: 25px;
  border-radius: 10px;
  border-left: 5px solid #4caf50;
  margin: 0 auto;
  max-width: 600px;
}

/* SECCIONES GENERALES */
.policy-content-section,
.ems-section,
.certification-history {
  background: white;
  border-radius: 15px;
  padding: 30px;
  margin-bottom: 30px;
  box-shadow: 0 5px 20px rgba(0,0,0,0.08);
  border: 1px solid #e8f5e8;
}

.section-header {
  display: flex;
  align-items: center;
  gap: 15px;
  margin-bottom: 30px;
  padding-bottom: 15px;
  border-bottom: 2px solid #e8f5e8;
}

.section-icon {
  font-size: 2rem;
}

.section-title {
  font-size: 1.8rem;
  font-weight: 600;
  color: #2e7d32;
  margin: 0;
}

/* PUNTOS DE POLÍTICA */
.policy-points {
  display: flex;
  flex-direction: column;
  gap: 25px;
}

.policy-point {
  display: flex;
  align-items: flex-start;
  gap: 20px;
  padding: 20px;
  background: #f9fdf9;
  border-radius: 10px;
  border-left: 4px solid #4caf50;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.policy-point:hover {
  transform: translateX(5px);
  box-shadow: 0 5px 15px rgba(76, 175, 80, 0.2);
}

.point-icon {
  font-size: 2rem;
  flex-shrink: 0;
}

.point-content {
  flex: 1;
}

.point-title {
  font-size: 1.2rem;
  font-weight: 600;
  color: #2e7d32;
  margin-bottom: 10px;
}

.initiatives-list {
  list-style: none;
  padding: 0;
  margin: 15px 0 0 0;
}

.initiative-item {
  display: flex;
  align-items: flex-start;
  gap: 10px;
  margin-bottom: 8px;
  padding: 8px 0;
}

.initiative-bullet {
  color: #4caf50;
  font-weight: bold;
  font-size: 1.2rem;
  min-width: 15px;
}

/* SECCIÓN EMS */
.ems-content {
  display: flex;
  flex-direction: column;
  gap: 30px;
}

.certification-info {
  display: flex;
  align-items: center;
  gap: 20px;
  padding: 20px;
  background: linear-gradient(135deg, #f1f8e9, #e8f5e8);
  border-radius: 10px;
}

.certification-badge {
  display: flex;
  align-items: center;
  gap: 10px;
  background: #4caf50;
  color: white;
  padding: 10px 20px;
  border-radius: 25px;
  font-weight: 600;
  flex-shrink: 0;
}

.badge-icon {
  font-size: 1.2rem;
}

.product-impact {
  padding: 25px;
  background: #f9fdf9;
  border-radius: 10px;
  border: 1px solid #e8f5e8;
}

.impact-title {
  color: #2e7d32;
  font-size: 1.3rem;
  margin-bottom: 15px;
}

.applications {
  display: flex;
  gap: 20px;
  margin-top: 20px;
  flex-wrap: wrap;
}

.application-item {
  display: flex;
  align-items: center;
  gap: 10px;
  padding: 10px 15px;
  background: white;
  border-radius: 8px;
  border: 1px solid #e8f5e8;
}

.app-icon {
  font-size: 1.2rem;
}

/* INICIATIVAS ADICIONALES */
.initiatives-title {
  color: #2e7d32;
  font-size: 1.3rem;
  margin-bottom: 20px;
}

.initiatives-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
  gap: 20px;
}

.initiative-card {
  background: white;
  padding: 25px;
  border-radius: 10px;
  text-align: center;
  border: 1px solid #e8f5e8;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.initiative-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 25px rgba(76, 175, 80, 0.15);
}

.card-icon {
  font-size: 3rem;
  margin-bottom: 15px;
}

.card-title {
  color: #2e7d32;
  font-size: 1.1rem;
  font-weight: 600;
  margin-bottom: 10px;
}

.card-description {
  color: #666;
  font-size: 0.95rem;
}

/* TIMELINE DE CERTIFICACIÓN */
.timeline {
  position: relative;
  padding-left: 30px;
}

.timeline::before {
  content: '';
  position: absolute;
  left: 15px;
  top: 0;
  bottom: 0;
  width: 2px;
  background: #4caf50;
}

.timeline-item {
  position: relative;
  margin-bottom: 40px;
  padding-left: 30px;
}

.timeline-item::before {
  content: '';
  position: absolute;
  left: -8px;
  top: 0;
  width: 16px;
  height: 16px;
  border-radius: 50%;
  background: #4caf50;
  border: 3px solid white;
  box-shadow: 0 0 0 3px #4caf50;
}

.timeline-date {
  background: #4caf50;
  color: white;
  padding: 8px 15px;
  border-radius: 20px;
  font-weight: 600;
  display: inline-block;
  margin-bottom: 10px;
}

.timeline-title {
  color: #2e7d32;
  font-size: 1.2rem;
  margin-bottom: 10px;
}

.certification-details {
  margin-top: 10px;
  padding: 10px;
  background: #f1f8e9;
  border-radius: 5px;
}

.cert-number {
  font-family: monospace;
  color: #2e7d32;
  font-weight: 600;
}

/* SECCIÓN DE COMPROMISO */
.commitment-section {
  background: linear-gradient(135deg, #2e7d32, #4caf50);
  color: white;
  padding: 50px 30px;
  border-radius: 15px;
  text-align: center;
}

.commitment-title {
  font-size: 2rem;
  margin-bottom: 20px;
  font-weight: 600;
}

.commitment-text {
  font-size: 1.2rem;
  max-width: 600px;
  margin: 0 auto 30px;
  opacity: 0.9;
}

.commitment-badges {
  display: flex;
  justify-content: center;
  gap: 20px;
  flex-wrap: wrap;
}

.badge {
  display: flex;
  align-items: center;
  gap: 10px;
  background: rgba(255,255,255,0.2);
  padding: 12px 20px;
  border-radius: 25px;
  backdrop-filter: blur(10px);
}

.badge-emoji {
  font-size: 1.2rem;
}

/* RESPONSIVE */
@media (max-width: 768px) {
  .environmental-policy {
    padding: 20px 15px;
  }
  
  .policy-main-title {
    font-size: 2.2rem;
  }
  
  .section-header {
    flex-direction: column;
    text-align: center;
    gap: 10px;
  }
  
  .policy-point {
    flex-direction: column;
    text-align: center;
    gap: 15px;
  }
  
  .certification-info {
    flex-direction: column;
    text-align: center;
  }
  
  .initiatives-grid {
    grid-template-columns: 1fr;
  }
  
  .timeline {
    padding-left: 20px;
  }
  
  .timeline::before {
    left: 10px;
  }
  
  .timeline-item {
    padding-left: 25px;
  }
  
  .commitment-badges {
    flex-direction: column;
    align-items: center;
  }
}

@media (max-width: 480px) {
  .policy-main-title {
    font-size: 1.8rem;
  }
  
  .section-title {
    font-size: 1.4rem;
  }
  
  .highlight-text {
    padding: 15px;
    font-size: 1.1rem;
  }
  
  .policy-content-section,
  .ems-section,
  .certification-history {
    padding: 20px;
  }
}
</style>