<?= $this->Html->css("index.css") ?>

<section class="u-align-center u-clearfix u-container-align-center u-white u-section-3" id="carousel_ba08">
    <div class="u-align-left u-container-align-center u-container-style u-list-item u-repeater-item u-shape-rectangle u-list-item-1"
        data-animation-name="customAnimationIn" data-animation-duration="1500">
        <div class="u-container-layout u-similar-container u-valign-middle u-container-layout-1">

            <!-- TÍTULO DE LA SECCIÓN -->
            <div class="section-title">
                <h2>Nuestro Fuerte</h2>
                <p>Excelencia y compromiso en cada servicio que ofrecemos</p>
            </div>

            <!-- TABS EN UNA SOLA LÍNEA -->
            <div class="tabs-container">
                <div class="tabs-header">
                    <button class="tab-button active" data-tab="presencia">
                        <span class="tab-icon">📍</span>
                        Presencia Nacional
                    </button>
                    <button class="tab-button" data-tab="soporte">
                        <span class="tab-icon">🛠️</span>
                        Soporte Técnico
                    </button>
                    <button class="tab-button" data-tab="calidad">
                        <span class="tab-icon">🔧</span>
                        Calidad Certificada
                    </button>
                </div>

                <!-- CONTENIDO DE LOS TABS -->
                <div class="tabs-content">
                    <!-- TAB 1: PRESENCIA -->
                    <div class="tab-panel active" id="presencia">
                        <div class="tab-content-wrapper">
                            <div class="tab-text">
                                <h3>Presencia en Todo el País</h3>
                                <ul class="feature-list">
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Cobertura nacional con logística optimizada</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Entrega y recolección de material eficiente</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Red de distribución estratégica en todo México</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Puntos de servicio en principales ciudades</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- TAB 2: SOPORTE -->
                    <div class="tab-panel" id="soporte">
                        <div class="tab-content-wrapper">
                            <div class="tab-text">
                                <h3>Soporte Técnico Especializado</h3>
                                <ul class="feature-list">
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Visita presencial personalizada</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Reacción rápida ante emergencias</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Asesoramiento técnico especializado</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Soporte 24/7 para clientes prioritarios</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- TAB 3: CALIDAD -->
                    <div class="tab-panel" id="calidad">
                        <div class="tab-content-wrapper">
                            <div class="tab-text">
                                <h3>Herramientas de la Más Alta Calidad</h3>
                                <ul class="feature-list">
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Certificación ISO 9001:2015</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Inspección precisa de calidad</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Materiales de primera calidad</span>
                                    </li>
                                    <li class="feature-item">
                                        <span class="feature-bullet">•</span>
                                        <span class="feature-text">Garantía extendida en todos nuestros productos</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- IMAGEN DEBAJO DE LOS TABS -->
            <!-- <div class="image-section">
                <img src="<?= $this->request->getAttribute('webroot') ?>img/nuestro_fuerte.png" alt="Nuestro Fuerte" class="main-image">
            </div> -->

        </div>
    </div>
</section>

<style>
    /* ESTILOS PARA LA SECCIÓN "NUESTRO FUERTE" */
    .section-title {
        text-align: center;
        margin-bottom: 50px;
    }
    
    .section-title h2 {
        font-size: 2.5rem;
        font-weight: 700;
        color: #333;
        margin-bottom: 10px;
    }
    
    .section-title p {
        font-size: 1.2rem;
        color: #666;
        max-width: 600px;
        margin: 0 auto;
    }
    
    /* CONTENEDOR DE TABS */
    .tabs-container {
        max-width: 1000px;
        margin: 0 auto 50px;
    }
    
    /* HEADER DE TABS EN UNA LÍNEA */
    .tabs-header {
        display: flex;
        justify-content: center;
        gap: 10px;
        margin-bottom: 30px;
        flex-wrap: wrap;
    }
    
    .tab-button {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 15px 25px;
        background: white;
        border: 2px solid #e0e0e0;
        border-radius: 50px;
        font-size: 1rem;
        font-weight: 600;
        color: #666;
        cursor: pointer;
        transition: all 0.3s ease;
        min-width: 180px;
        justify-content: center;
    }
    
    .tab-button:hover {
        border-color: #f05510;
        color: #f05510;
        transform: translateY(-2px);
    }
    
    .tab-button.active {
        background: #f05510;
        border-color: #f05510;
        color: white;
        box-shadow: 0 5px 15px rgba(240, 85, 16, 0.3);
    }
    
    .tab-icon {
        font-size: 1.2rem;
    }
    
    /* CONTENIDO DE TABS */
    .tabs-content {
        background: white;
        border-radius: 15px;
        padding: 40px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        min-height: 250px;
    }
    
    .tab-panel {
        display: none;
    }
    
    .tab-panel.active {
        display: block;
        animation: fadeIn 0.5s ease;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    .tab-content-wrapper {
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .tab-text {
        flex: 1;
        max-width: 600px;
    }
    
    .tab-text h3 {
        font-size: 1.8rem;
        font-weight: 700;
        color: #f05510;
        margin-bottom: 25px;
        text-align: center;
    }
    
    .feature-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        gap: 15px;
        margin-bottom: 15px;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .feature-item:last-child {
        border-bottom: none;
        margin-bottom: 0;
    }
    
    .feature-bullet {
        color: #f05510;
        font-weight: bold;
        font-size: 1.3rem;
        min-width: 20px;
    }
    
    .feature-text {
        font-size: 1.1rem;
        color: #555;
        line-height: 1.5;
        flex: 1;
    }
    
    /* SECCIÓN DE IMAGEN */
    .image-section {
        text-align: center;
        margin-top: 30px;
    }
    
    .main-image {
        max-width: 600px;
        width: 100%;
        height: auto;
        border-radius: 15px;
        box-shadow: 0 15px 40px rgba(0,0,0,0.15);
        transition: transform 0.3s ease;
    }
    
    .main-image:hover {
        transform: translateY(-5px);
    }
    
    /* RESPONSIVE */
    @media (max-width: 768px) {
        .tabs-header {
            flex-direction: column;
            align-items: center;
        }
        
        .tab-button {
            width: 100%;
            max-width: 300px;
        }
        
        .tabs-content {
            padding: 30px 20px;
        }
        
        .tab-text h3 {
            font-size: 1.5rem;
        }
        
        .feature-text {
            font-size: 1rem;
        }
        
        .section-title h2 {
            font-size: 2rem;
        }
    }
    
    @media (max-width: 480px) {
        .tabs-content {
            padding: 20px 15px;
        }
        
        .tab-text h3 {
            font-size: 1.3rem;
        }
        
        .feature-item {
            flex-direction: column;
            gap: 8px;
            text-align: center;
        }
        
        .feature-bullet {
            align-self: center;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const tabButtons = document.querySelectorAll('.tab-button');
        const tabPanels = document.querySelectorAll('.tab-panel');
        
        tabButtons.forEach(button => {
            button.addEventListener('click', function() {
                const targetTab = this.getAttribute('data-tab');
                
                // Remover clase active de todos los botones y paneles
                tabButtons.forEach(btn => btn.classList.remove('active'));
                tabPanels.forEach(panel => panel.classList.remove('active'));
                
                // Agregar clase active al botón clickeado y panel correspondiente
                this.classList.add('active');
                document.getElementById(targetTab).classList.add('active');
            });
        });
    });
</script>