
         <?= $this->Html->css("index.css") ?>
<section id="compromiso-calidad" class="quality-commitment">
  <div class="policy-header">
    <h2 class="policy-main-title">Compromiso con la Calidad</h2>
    <div class="policy-intro">
      <h3 class="policy-subtitle">Filosofía Básica</h3>
      <div class="intro-content">
        <p class="highlight-text">
          <strong>Contribuir al mundo en general mediante el suministro estable de productos de calidad superior</strong>
        </p>
      </div>
    </div>
  </div>

  <!-- POLÍTICA DE CALIDAD -->
  <div class="policy-content-section">
    <div class="section-header">
      <span class="section-icon">🏆</span>
      <h3 class="section-title">Política de Calidad</h3>
    </div>
    
    <div class="policy-points">
      <div class="policy-point">
        <div class="point-icon">📋</div>
        <div class="point-content">
          <h4 class="point-title">Planificación Centrada en el Cliente</h4>
          <p>Planificar la realización de productos que respondan a las necesidades y expectativas de los clientes, y suministrarlos de manera estable.</p>
        </div>
      </div>

      <div class="policy-point">
        <div class="point-icon">⚖️</div>
        <div class="point-content">
          <h4 class="point-title">Cumplimiento Normativo</h4>
          <p>Cumplir con las leyes, regulaciones y requisitos aplicables relevantes.</p>
        </div>
      </div>

      <div class="policy-point">
        <div class="point-icon">🎯</div>
        <div class="point-content">
          <h4 class="point-title">Establecimiento de Metas</h4>
          <p>Se establecerán objetivos de calidad para lograr estas metas, y todos los empleados trabajarán juntos para alcanzarlos.</p>
        </div>
      </div>

      <div class="policy-point">
        <div class="point-icon">📈</div>
        <div class="point-content">
          <h4 class="point-title">Mejora Continua</h4>
          <p>Mejorar continuamente el sistema de gestión de calidad.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- SISTEMA DE GESTIÓN DE CALIDAD -->
  <div class="qms-section">
    <div class="section-header">
      <span class="section-icon">🌐</span>
      <h3 class="section-title">Sistema de Gestión de Calidad (QMS)</h3>
    </div>
    
    <div class="qms-content">
      <div class="certification-info">
        <div class="certification-badge">
          <span class="badge-icon">✅</span>
          <span class="badge-text">ISO 9001 Certificado</span>
        </div>
        <p>
          El Grupo Asahi Diamond ha establecido un QMS (Sistema de Gestión de Calidad) en todas sus plantas nacionales, 
          así como en sus subsidiarias en el extranjero: Asahi Diamond Europe, Asahi Diamond Indonesia, 
          Taiwan Asahi Diamond Industrial, Shanghai Asahi Diamond Industrial, y han obtenido la certificación ISO 9001.
        </p>
      </div>

      <div class="production-system">
        <h4 class="system-title">Sistema de Producción Integrado</h4>
        <p>
          Nuestro grupo ha construido un sistema de producción con seis bases en Japón para proporcionar productos de alta calidad. 
          Las bases de producción nacionales y extranjeras cooperan proactivamente para intercambiar recursos humanos y tecnología 
          para garantizar alta calidad en todos los productos.
        </p>
      </div>
    </div>
  </div>

  <!-- HISTORIAL DE CERTIFICACIÓN ISO 9001 -->
  <div class="certification-history">
    <div class="section-header">
      <span class="section-icon">📅</span>
      <h3 class="section-title">Historial de Certificación ISO 9001</h3>
    </div>
    
    <div class="timeline">
      <div class="timeline-item">
        <div class="timeline-date">Mayo 1995</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Primera Certificación</h4>
          <p>Planta Chiba Tsurumai obtuvo la certificación ISO 9002:1994 de JQA.</p>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Diciembre 1995</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Consolidación</h4>
          <p>Planta Chiba Tsurumai obtuvo la certificación ISO 9002:1994 de JQA.</p>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Junio 1997</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Expansión</h4>
          <p>Plantas Mie y Tamagawa adquirieron la certificación ISO 9002:1994 de JCQA.</p>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Enero 2003</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Nueva Base</h4>
          <p>Yamanashi Asahi Diamond certificado ISO 9002:1994 por JCQA.</p>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Enero 2004</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Integración y Actualización</h4>
          <p>Plantas Mie, Tamagawa y Chiba Tsurumai integradas - Transición a versión ISO 9001:2000</p>
          <div class="certification-details">
            <span class="cert-number">Número de Registro: JCQA-0096</span>
          </div>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Noviembre 2009</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Integración Completa</h4>
          <p>Integración de Yamanashi Asahi Diamond.</p>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Diciembre 2016</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Actualización del Sistema</h4>
          <p>Transición a ISO 9001:2008</p>
        </div>
      </div>

      <div class="timeline-item">
        <div class="timeline-date">Diciembre 2016</div>
        <div class="timeline-content">
          <h4 class="timeline-title">Certificación Actual</h4>
          <p>Transición a ISO 9001:2015 e integración de Koremura Co.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- COMPROMISO CON LA CALIDAD -->
  <div class="quality-commitment-details">
    <div class="commitment-grid">
      <div class="commitment-card">
        <div class="card-header">
          <span class="card-icon">🔧</span>
          <h4 class="card-title">Capacidad de Producción Avanzada</h4>
        </div>
        <p class="card-content">
          Mientras los requisitos de los clientes se han vuelto más exigentes año tras año, hemos mantenido 
          la actitud de proporcionar productos que superan las expectativas de los clientes con nuestras 
          capacidades de producción respaldadas por tecnología avanzada.
        </p>
      </div>

      <div class="commitment-card">
        <div class="card-header">
          <span class="card-icon">💎</span>
          <h4 class="card-title">Importancia de la Calidad</h4>
        </div>
        <p class="card-content">
          Dado que las herramientas de diamante se utilizan para procesar materiales industriales costosos 
          en una amplia gama de industrias, es muy importante estabilizar su calidad y suministro.
        </p>
      </div>

      <div class="commitment-card">
        <div class="card-header">
          <span class="card-icon">🔄</span>
          <h4 class="card-title">Mejora Continua</h4>
        </div>
        <p class="card-content">
          Debemos desarrollar arreglos para realizar una producción estable y garantizar la calidad de los 
          productos, mientras exploramos posibles mejoras.
        </p>
      </div>
    </div>
  </div>

  <!-- ESFUERZOS DE ESTABILIZACIÓN -->
  <div class="stabilization-efforts">
    <div class="section-header">
      <span class="section-icon">🛡️</span>
      <h3 class="section-title">Esfuerzos Exhaustivos para Estabilizar el Suministro</h3>
    </div>
    
    <div class="process-steps">
      <div class="process-step">
        <div class="step-number">1</div>
        <div class="step-content">
          <h4 class="step-title">Cada Proceso Cuenta</h4>
          <p>Cada proceso debe garantizar un suministro estable. Respaldando la alta calidad de nuestros productos hay un sistema para garantizar un suministro estable en todos los procesos de compra, producción, inspección y entrega.</p>
        </div>
      </div>

      <div class="process-step">
        <div class="step-number">2</div>
        <div class="step-content">
          <h4 class="step-title">Adquisición de Materiales</h4>
          <p>Para la compra de materiales, hemos desarrollado un sistema para procurar materiales estrictamente seleccionados que garanticen un suministro estable a través de rutas confiables.</p>
        </div>
      </div>

      <div class="process-step">
        <div class="step-number">3</div>
        <div class="step-content">
          <h4 class="step-title">Sistemas de Manufactura</h4>
          <p>En cuanto a los sistemas de manufactura, registramos fechas para mantenimientos rutinarios. Además, garantizamos una gestión exhaustiva en cada frente de manufactura para mantener alta precisión.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- SATISFACCIÓN DEL CLIENTE -->
  <div class="customer-satisfaction">
    <div class="section-header">
      <span class="section-icon">⭐</span>
      <h3 class="section-title">Buscando Superar las Expectativas del Cliente</h3>
    </div>
    
    <div class="satisfaction-content">
      <div class="stats-section">
        <div class="stat-card">
          <div class="stat-number">90%</div>
          <div class="stat-label">de productos son hechos por pedido</div>
        </div>
        <p class="stat-description">
          Aproximadamente el 90% de nuestros productos se producen por pedido de los clientes. 
          Dado que producir los productos más valiosos para los clientes es lo más importante, 
          vemos nuestros procesos de producción como cubriendo nuestra entrega de productos a 
          los clientes para obtener su satisfacción.
        </p>
      </div>

      <div class="value-proposition">
        <h4 class="value-title">Añadiendo Valor a Nuestros Productos</h4>
        <div class="value-points">
          <div class="value-point">
            <span class="value-icon">🚚</span>
            <span class="value-text">Enviamos productos que cumplen con los diferentes requisitos de los clientes en sus respectivos mejores estados</span>
          </div>
          <div class="value-point">
            <span class="value-icon">👨‍💼</span>
            <span class="value-text">Enviamos ingenieros a los clientes según sea necesario para escuchar sus solicitudes</span>
          </div>
          <div class="value-point">
            <span class="value-icon">💎</span>
            <span class="value-text">Creemos que esta práctica puede añadir valor a nuestros productos</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- COMPROMISO FINAL -->
  <div class="final-commitment">
    <div class="commitment-content">
      <h3 class="commitment-title">Nuestro Compromiso de Calidad</h3>
      <p class="commitment-text">
        En el futuro, todas las bases de producción estarán unidas para proporcionar servicios integrales, 
        manteniendo nuestro compromiso inquebrantable con la excelencia y la satisfacción del cliente.
      </p>
      <div class="commitment-badges">
        <div class="badge">
          <span class="badge-emoji">🏆</span>
          <span class="badge-label">Calidad Certificada</span>
        </div>
        <div class="badge">
          <span class="badge-emoji">⚡</span>
          <span class="badge-label">Tecnología Avanzada</span>
        </div>
        <div class="badge">
          <span class="badge-emoji">🤝</span>
          <span class="badge-label">Satisfacción del Cliente</span>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
.quality-commitment {
  max-width: 1200px;
  margin: 0 auto;
  padding: 40px 20px;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  line-height: 1.6;
  color: #333;
}

/* HEADER */
.policy-header {
  text-align: center;
  margin-bottom: 50px;
  padding: 40px 0;
  background: linear-gradient(135deg, #fff3e0 0%, #ffe0b2 100%);
  border-radius: 15px;
}

.policy-main-title {
  font-size: 2.8rem;
  font-weight: 700;
  color: #e65100;
  margin-bottom: 20px;
  background: linear-gradient(135deg, #e65100, #ff9800);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}

.policy-subtitle {
  font-size: 1.5rem;
  color: #f57c00;
  margin-bottom: 25px;
  font-weight: 600;
}

.highlight-text {
  font-size: 1.3rem;
  background: rgba(255, 152, 0, 0.1);
  padding: 25px;
  border-radius: 10px;
  border-left: 5px solid #ff9800;
  margin: 0 auto;
  max-width: 600px;
}

/* SECCIONES GENERALES */
.policy-content-section,
.qms-section,
.certification-history,
.quality-commitment-details,
.stabilization-efforts,
.customer-satisfaction {
  background: white;
  border-radius: 15px;
  padding: 30px;
  margin-bottom: 30px;
  box-shadow: 0 5px 20px rgba(0,0,0,0.08);
  border: 1px solid #ffe0b2;
}

.section-header {
  display: flex;
  align-items: center;
  gap: 15px;
  margin-bottom: 30px;
  padding-bottom: 15px;
  border-bottom: 2px solid #ffe0b2;
}

.section-icon {
  font-size: 2rem;
}

.section-title {
  font-size: 1.8rem;
  font-weight: 600;
  color: #e65100;
  margin: 0;
}

/* PUNTOS DE POLÍTICA */
.policy-points {
  display: flex;
  flex-direction: column;
  gap: 25px;
}

.policy-point {
  display: flex;
  align-items: flex-start;
  gap: 20px;
  padding: 20px;
  background: #fffbf2;
  border-radius: 10px;
  border-left: 4px solid #ff9800;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.policy-point:hover {
  transform: translateX(5px);
  box-shadow: 0 5px 15px rgba(255, 152, 0, 0.2);
}

.point-icon {
  font-size: 2rem;
  flex-shrink: 0;
}

.point-content {
  flex: 1;
}

.point-title {
  font-size: 1.2rem;
  font-weight: 600;
  color: #e65100;
  margin-bottom: 10px;
}

/* SECCIÓN QMS */
.qms-content {
  display: flex;
  flex-direction: column;
  gap: 30px;
}

.certification-info {
  display: flex;
  align-items: center;
  gap: 20px;
  padding: 20px;
  background: linear-gradient(135deg, #fff8e1, #fff3e0);
  border-radius: 10px;
}

.certification-badge {
  display: flex;
  align-items: center;
  gap: 10px;
  background: #ff9800;
  color: white;
  padding: 10px 20px;
  border-radius: 25px;
  font-weight: 600;
  flex-shrink: 0;
}

.badge-icon {
  font-size: 1.2rem;
}

.production-system {
  padding: 25px;
  background: #fffbf2;
  border-radius: 10px;
  border: 1px solid #ffe0b2;
}

.system-title {
  color: #e65100;
  font-size: 1.3rem;
  margin-bottom: 15px;
}

/* TIMELINE DE CERTIFICACIÓN */
.timeline {
  position: relative;
  padding-left: 30px;
}

.timeline::before {
  content: '';
  position: absolute;
  left: 15px;
  top: 0;
  bottom: 0;
  width: 2px;
  background: #ff9800;
}

.timeline-item {
  position: relative;
  margin-bottom: 40px;
  padding-left: 30px;
}

.timeline-item::before {
  content: '';
  position: absolute;
  left: -8px;
  top: 0;
  width: 16px;
  height: 16px;
  border-radius: 50%;
  background: #ff9800;
  border: 3px solid white;
  box-shadow: 0 0 0 3px #ff9800;
}

.timeline-date {
  background: #ff9800;
  color: white;
  padding: 8px 15px;
  border-radius: 20px;
  font-weight: 600;
  display: inline-block;
  margin-bottom: 10px;
}

.timeline-title {
  color: #e65100;
  font-size: 1.2rem;
  margin-bottom: 10px;
}

.certification-details {
  margin-top: 10px;
  padding: 10px;
  background: #fff8e1;
  border-radius: 5px;
}

.cert-number {
  font-family: monospace;
  color: #e65100;
  font-weight: 600;
}

/* COMPROMISOS DE CALIDAD */
.commitment-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
  gap: 25px;
}

.commitment-card {
  background: white;
  padding: 25px;
  border-radius: 10px;
  border: 1px solid #ffe0b2;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.commitment-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 25px rgba(255, 152, 0, 0.15);
}

.card-header {
  display: flex;
  align-items: center;
  gap: 15px;
  margin-bottom: 15px;
}

.card-icon {
  font-size: 2.5rem;
}

.card-title {
  color: #e65100;
  font-size: 1.2rem;
  font-weight: 600;
  margin: 0;
}

/* PROCESOS DE ESTABILIZACIÓN */
.process-steps {
  display: flex;
  flex-direction: column;
  gap: 25px;
}

.process-step {
  display: flex;
  align-items: flex-start;
  gap: 20px;
  padding: 25px;
  background: #fffbf2;
  border-radius: 10px;
  border-left: 4px solid #ff9800;
}

.step-number {
  background: #ff9800;
  color: white;
  width: 40px;
  height: 40px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  font-weight: bold;
  font-size: 1.2rem;
  flex-shrink: 0;
}

.step-content {
  flex: 1;
}

.step-title {
  color: #e65100;
  font-size: 1.2rem;
  margin-bottom: 10px;
  font-weight: 600;
}

/* SATISFACCIÓN DEL CLIENTE */
.satisfaction-content {
  display: flex;
  flex-direction: column;
  gap: 30px;
}

.stats-section {
  text-align: center;
  padding: 30px;
  background: linear-gradient(135deg, #fff8e1, #fff3e0);
  border-radius: 10px;
}

.stat-card {
  margin-bottom: 20px;
}

.stat-number {
  font-size: 4rem;
  font-weight: bold;
  color: #ff9800;
  line-height: 1;
}

.stat-label {
  font-size: 1.1rem;
  color: #e65100;
  font-weight: 600;
}

.stat-description {
  font-size: 1.1rem;
  color: #666;
  max-width: 600px;
  margin: 0 auto;
}

.value-proposition {
  padding: 25px;
  background: #fffbf2;
  border-radius: 10px;
}

.value-title {
  color: #e65100;
  font-size: 1.3rem;
  margin-bottom: 20px;
  text-align: center;
}

.value-points {
  display: flex;
  flex-direction: column;
  gap: 15px;
}

.value-point {
  display: flex;
  align-items: center;
  gap: 15px;
  padding: 15px;
  background: white;
  border-radius: 8px;
  border: 1px solid #ffe0b2;
}

.value-icon {
  font-size: 1.5rem;
  flex-shrink: 0;
}

.value-text {
  flex: 1;
  font-weight: 500;
}

/* COMPROMISO FINAL */
.final-commitment {
  background: linear-gradient(135deg, #e65100, #ff9800);
  color: white;
  padding: 50px 30px;
  border-radius: 15px;
  text-align: center;
}

.commitment-title {
  font-size: 2rem;
  margin-bottom: 20px;
  font-weight: 600;
}

.commitment-text {
  font-size: 1.2rem;
  max-width: 600px;
  margin: 0 auto 30px;
  opacity: 0.9;
}

.commitment-badges {
  display: flex;
  justify-content: center;
  gap: 20px;
  flex-wrap: wrap;
}

.badge {
  display: flex;
  align-items: center;
  gap: 10px;
  background: rgba(255,255,255,0.2);
  padding: 12px 20px;
  border-radius: 25px;
  backdrop-filter: blur(10px);
}

.badge-emoji {
  font-size: 1.2rem;
}

/* RESPONSIVE */
@media (max-width: 768px) {
  .quality-commitment {
    padding: 20px 15px;
  }
  
  .policy-main-title {
    font-size: 2.2rem;
  }
  
  .section-header {
    flex-direction: column;
    text-align: center;
    gap: 10px;
  }
  
  .policy-point {
    flex-direction: column;
    text-align: center;
    gap: 15px;
  }
  
  .certification-info {
    flex-direction: column;
    text-align: center;
  }
  
  .commitment-grid {
    grid-template-columns: 1fr;
  }
  
  .timeline {
    padding-left: 20px;
  }
  
  .timeline::before {
    left: 10px;
  }
  
  .timeline-item {
    padding-left: 25px;
  }
  
  .process-step {
    flex-direction: column;
    text-align: center;
    gap: 15px;
  }
  
  .value-point {
    flex-direction: column;
    text-align: center;
    gap: 10px;
  }
  
  .commitment-badges {
    flex-direction: column;
    align-items: center;
  }
}

@media (max-width: 480px) {
  .policy-main-title {
    font-size: 1.8rem;
  }
  
  .section-title {
    font-size: 1.4rem;
  }
  
  .highlight-text {
    padding: 15px;
    font-size: 1.1rem;
  }
  
  .policy-content-section,
  .qms-section,
  .certification-history,
  .quality-commitment-details,
  .stabilization-efforts,
  .customer-satisfaction {
    padding: 20px;
  }
  
  .stat-number {
    font-size: 3rem;
  }
}
</style>